package android.reader;



import android.reader.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

public class Demo extends Activity {
    /** Called when the activity is first created. */	 
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
       
       
       final Button buttonSetup = (Button)findViewById(R.id.ButtonSetup);
       buttonSetup.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				startActivity(new Intent(Demo.this, SerialPortPreferences.class));
			}
		});

       final Button buttonConsole = (Button)findViewById(R.id.ButtonConsole);
       buttonConsole.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				startActivity(new Intent(Demo.this, iso14443a.class));
			}
		});
       
       final Button buttonCPUOperate = (Button)findViewById(R.id.ButtonCPUOperate);
       buttonCPUOperate.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				startActivity(new Intent(Demo.this, CPUCardOperate.class));
			}
		});

       final Button buttonAbout = (Button)findViewById(R.id.ButtonAbout);
       buttonAbout.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				AlertDialog.Builder builder = new AlertDialog.Builder(Demo.this);
				builder.setTitle("About");
				builder.setMessage(R.string.about_msg);
				builder.show();
			}
		});

       final Button buttonQuit = (Button)findViewById(R.id.ButtonQuit);
       buttonQuit.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				Demo.this.onDestroy();
			}
		});	
    }    
    @Override
	protected void onDestroy() {
		super.onDestroy();
		System.exit(0);		
	} 
}